/*
 * Decompiled with CFR 0.152.
 */
package graph.generator;

import graph.generator.GraphFunctions;
import graph.generator.PairGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import shared.Edge;
import shared.Node;
import shared.Pair;
import shared.Table;
import shared.Translation;

public class Graph {
    private final HashSet<Node> nodes = new HashSet();
    private final HashSet<Edge> edges = new HashSet();
    private static int count = 0;

    public Graph() {
    }

    public Graph(Table table, GraphFunctions.GFunction f) {
        this.addNodes(new PairGenerator(table, f).generatePairs());
    }

    public HashSet<Node> getNodes() {
        return this.nodes;
    }

    public HashSet<Edge> getEdges() {
        return this.edges;
    }

    public void addNodes(Collection<Pair> pairs) {
        pairs.forEach(pair -> this.nodes.add(new Node((Pair)pair)));
        this.fixGraph();
    }

    public String toString() {
        String result = "";
        for (Edge e : this.edges) {
            result = result + e.toString();
        }
        return result.replaceAll("\\[", "{").replaceAll("\\]", "}");
    }

    public String toTags() {
        String result = "";
        for (Node x : this.nodes) {
            result = x.getLinkedNodes().stream().map(n -> "\"" + n.toTag(true) + "\" -- \"" + x.toTag(true) + "\";").reduce(result, String::concat);
        }
        return result.replaceAll("\\[", "{").replaceAll("\\]", "}");
    }

    private void fixClassicGraph() {
        HashSet toRemove = new HashSet();
        this.nodes.forEach(n -> this.nodes.forEach(n2 -> {
            if (!n.equals(n2) && n2.getLabel().emptyDifference(n.getLabel()) && n.getLabel().sameAttributes(n2.getLabel())) {
                toRemove.add(n2);
            }
        }));
        this.nodes.removeAll(toRemove);
    }

    public HashSet<Node> getColoredNodes(String s) {
        return new HashSet<Node>(this.nodes.stream().filter(n -> n.isColored(s)).collect(Collectors.toSet()));
    }

    public HashSet<Edge> getColoredEdges(String s) {
        return new HashSet<Edge>(this.edges.stream().filter(e -> e.isColored(s)).collect(Collectors.toSet()));
    }

    private void fixGraph() {
        if (PairGenerator.getFunction() == GraphFunctions.GFunction.CLASSIC) {
            this.fixClassicGraph();
        }
        this.nodes.forEach(n -> this.nodes.forEach(n2 -> {
            if (n.includes((Node)n2)) {
                n2.getLinkedNodes().add((Node)n);
            }
        }));
        this.nodes.forEach(n -> {
            HashSet toRemove = new HashSet();
            n.getLinkedNodes().forEach(n2 -> {
                if (n.getLinkedNodes().contains(n2)) {
                    toRemove.addAll(n2.getLinkedNodes());
                }
            });
            n.getLinkedNodes().removeAll(toRemove);
            n.getLinkedNodes().forEach(n2 -> this.edges.add(new Edge((Node)n2, (Node)n)));
        });
        ArrayList<Node> arrNodes = new ArrayList<Node>(this.nodes);
        arrNodes.sort(new Node.NodeComparator());
        count = 0;
        arrNodes.forEach(n -> n.setTag("n" + count++));
        this.nodes.clear();
        this.nodes.addAll(arrNodes);
    }

    public ArrayList<Translation> getLegend() {
        ArrayList<Translation> result = new ArrayList<Translation>();
        this.nodes.forEach(n -> result.add(new Translation(n.toString(), n.toTag(true))));
        result.sort(new Translation.TranslationComparator());
        return result;
    }
}

